% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagination.R
\name{vert_pag_indices}
\alias{vert_pag_indices}
\title{Find column indices for vertical pagination}
\usage{
vert_pag_indices(
  obj,
  cpp = 40,
  colwidths = NULL,
  verbose = FALSE,
  rep_cols = 0L,
  fontspec,
  nosplitin = character(),
  round_type = c("iec", "sas")
)
}
\arguments{
\item{obj}{(\code{ANY})\cr object to be paginated. Must have a \code{\link[=matrix_form]{matrix_form()}} method.}

\item{cpp}{(\code{numeric(1)})\cr number of characters per page (width).}

\item{colwidths}{(\code{numeric})\cr vector of column widths (in characters) for use in vertical pagination.}

\item{verbose}{(\code{flag})\cr whether additional informative messages about the search for
pagination breaks should be shown. Defaults to \code{FALSE}.}

\item{rep_cols}{(\code{numeric(1)})\cr number of \emph{columns} (not including row labels) to be repeated on every page.
Defaults to 0.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[=font_spec]{font_spec()}}.}

\item{nosplitin}{(\code{character})\cr list of names of subtables where page breaks are not allowed, regardless of other
considerations. Defaults to none.}

\item{round_type}{(\code{"iec"} or \code{"sas"})\cr the type of rounding to perform. iec,
the default, peforms rounding compliant with IEC 60559 (see details), while
sas performs nearest-value rounding consistent with rounding within SAS.}
}
\value{
A \code{list} partitioning the vector of column indices into subsets for 1 or more horizontally paginated pages.
}
\description{
Find column indices for vertical pagination
}
\examples{
mf <- basic_matrix_form(df = mtcars)
colpaginds <- vert_pag_indices(mf, fontspec = font_spec())
lapply(colpaginds, function(j) mtcars[, j, drop = FALSE])

}
