% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{FM_message}
\alias{FM_message}
\title{Show Message to User}
\usage{
FM_message(line, escape_braces = TRUE, entry_type = "alert")
}
\arguments{
\item{line}{Text to display}

\item{escape_braces}{Set to \code{TRUE} (default) to escape curly braces in the entry, set to \code{FALSE} to have the values interpreted.}

\item{entry_type}{Set to either "alert"(default), "danger", "info", "success", "warning", "h1", "h2", or "h3"}
}
\value{
Returns NULL
}
\description{
Writes a message to the console depending on whether cli is
installed or not.
}
\examples{
mr = FM_message("This is a normal  message")
mr = FM_message("This is a danger  message", entry_type="danger")
mr = FM_message("This is a info    message", entry_type="info")
mr = FM_message("This is a success message", entry_type="success")
mr = FM_message("This is a warning message", entry_type="warning")
mr = FM_message("This is an H1 header",      entry_type="h1")
mr = FM_message("This is an H2 header",      entry_type="h2")
mr = FM_message("This is an H3 header",      entry_type="h3")
}
