#' terms
#' 
#' terms method for call and expression objects
#'
#' @param x A call object
#' @param ...  Arguments passed to \code{\link{terms.formula}}
#' 
#' This S3 method returns a terms object for a call methods using a dispatch to
#' \code{ terms.formula }.
#' 
#' The terms are generated by making a rhs only call to \code{ terms.formula }.
#' 
#' \code{data} is only needed and must be explicitly specified, i.e.  \code{
#' data = } if there are special elements such as '.'.  Otherwise the
#' \code{data} argument is unused.
#' 
#' Some edge cases may not be supported.
#' 
#' @return A terms object.  See \code{\link{terms.object}} for details.
#' 
#' @author Christopher Brown
#' 
#' @seealso \code{\link{terms.object}} and \code{\link{terms.formula}}
#' 
#' @keywords manip symbolmath utilities
#' @examples
#' 
#'     terms( quote( A + B ) )
#' 
#'     data(iris) 
#'     x <- terms( quote( . - Species ) , data=iris ) 
#' 
#' @aliases terms.call terms.expression terms
#' @rdname terms
#' @export 

terms.call <- function( x , ...  ) 
{

  if( deparse( x[[1]] ) %in% c( operators() ) ) 
  { 
    all.vars(x) 
  } else {  
    form <- formula( paste( '~', as.expression( x ) ) )
    terms( form, ... )
  }

}
   
#' @rdname terms
#' @method terms expression
#' @export 

terms.expression <- function(x,...) lapply(x, terms, ... )  
