% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dprofile.R
\name{plot_dprofile}
\alias{plot_dprofile}
\title{plot_dprofile}
\usage{
plot_dprofile(x, taxon)
}
\arguments{
\item{x}{The list output of @seealso densify}

\item{taxon}{A character vector of length one, specifying
one of the taxon names in x to be plotted}
}
\value{
NULL, the plotted density profile
}
\description{
Function to plot density profiles of occurrences through
time using the output of @seealso densify.
}
\examples{
# load dataset
data("brachios")
# subsample brachios to make for a short example runtime
set.seed(1)
brachios <- brachios[sample(1:nrow(brachios), 1000),]
# densify ranges
dens <- densify(brachios)
plot_dprofile(dens, "Atrypa")
}
