% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Gibbs_4PNO}
\alias{Gibbs_4PNO}
\title{Gibbs Implementation of 4PNO}
\usage{
Gibbs_4PNO(Y, mu_xi, Sigma_xi_inv, mu_theta, Sigma_theta_inv, alpha_c, beta_c,
  alpha_s, beta_s, burnin, cTF, sTF, gwg_reps, chain_length = 10000L)
}
\arguments{
\item{Y}{A N by J \code{matrix} of item responses.}

\item{mu_xi}{A two dimensional \code{vector} of prior item parameter means.}

\item{Sigma_xi_inv}{A two dimensional \code{matrix} of prior for the inverse item parameter variance-covariance matrix.}

\item{mu_theta}{The prior mean for theta.}

\item{Sigma_theta_inv}{The prior inverse variance for theta.}

\item{alpha_c}{The lower asymptote prior 'a' parameter.}

\item{beta_c}{The lower asymptote prior 'b' parameter.}

\item{alpha_s}{The upper asymptote prior 'a' parameter.}

\item{beta_s}{The upper asymptote prior 'b' parameter.}

\item{burnin}{The number of MCMC samples to discard. Note that if burnin < chain_length that }

\item{cTF}{A J dimensional \code{vector} indicating which lower asymptotes to estimate. 0 = exclude lower asymptote and 1 = include lower asymptote.}

\item{sTF}{A J dimensional \code{vector} indicating which upper asymptotes to estimate. 0 = exclude upper asymptote and 1 = include upper asymptote.}

\item{gwg_reps}{The number of Gibbs within Gibbs MCMC samples for marginal distribution of gamma. Values between 5 to 10 are adequate.}

\item{chain_length}{The number of MCMC samples.}
}
\value{
Samples from posterior.
}
\description{
Internal function to -2LL
}
\author{
Steven Andrew Culpepper
}

\examples{
require(fourPNO)
#simulate small 4PNO dataset to demonstrate function
J = 5
N = 100
  #population item parameters
  as_t = rnorm(J,mean=2,sd=.5)
  bs_t = rnorm(J,mean=0,sd=.5)
  #sampling gs and ss with truncation
  gs_t = rbeta(J,1,8)
    ps_g = pbeta(1-gs_t,1,8)
  ss_t = qbeta(runif(J)*ps_g,1,8)
theta_t <- rnorm(N)
Y_t = Y_4pno_simulate(N,J,as=as_t,bs=bs_t,gs=gs_t,ss=ss_t,theta=theta_t)

#setting prior parameters
mu_theta=0
Sigma_theta_inv=1
mu_xi = c(0,0)
alpha_c=alpha_s=beta_c=beta_s=1
Sigma_xi_inv = solve(2*matrix(c(1,0,0,1),2,2))
burnin = 1000
#Execute Gibbs sampler
out_t <- Gibbs_4PNO(Y_t,mu_xi,Sigma_xi_inv,mu_theta,Sigma_theta_inv,alpha_c,beta_c,alpha_s,
                    beta_s,burnin,rep(1,J),rep(1,J),gwg_reps=5,chain_length=burnin*2)

#summarizing posterior distribution
OUT = cbind(apply(out_t$AS[,-c(1:burnin)],1,mean),apply(out_t$BS[,-c(1:burnin)],1,mean),
            apply(out_t$GS[,-c(1:burnin)],1,mean),apply(out_t$SS[,-c(1:burnin)],1,mean),
            apply(out_t$AS[,-c(1:burnin)],1,sd),apply(out_t$BS[,-c(1:burnin)],1,sd),
            apply(out_t$GS[,-c(1:burnin)],1,sd),apply(out_t$SS[,-c(1:burnin)],1,sd) )
OUT = cbind(1:J,OUT)
colnames(OUT) = c('Item','as','bs','gs','ss','as_sd','bs_sd','gs_sd','ss_sd')
print(OUT,digits=3)
}

