% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.R
\name{rk}
\alias{rk}
\title{kernel function}
\usage{
rk(grid, sigma = 1, r, tol = 1e-08)
}
\arguments{
\item{grid}{grid of points where the kernel function is evaluated.}

\item{sigma}{is the temperature of the kernel (standard deviation)}

\item{r}{the dimension of the basis system of the Gran matrix (K). If
missing then r is the rank of K.}

\item{tol}{A tolerance to keep the first d eigenvalues of A. Default =
1e-08.}
}
\value{
\item{grid}{grid of points where the kernel function is evaluated.}
\item{K}{Kernel Gram matrix} \item{U}{first r eigenvectors of K using svd.}
\item{D}{first r eigenvectors of K using svd.}
}
\description{
Computes the Gram matrix of the gaussian kernel over a grid of values and
computes its singular value decomposition.
}
\examples{

grid = seq(0,1,,100)
rk(grid, sigma = 1)

}
\author{
J. Cugliari and N. Hernández
}
