% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_bar}
\alias{plot_bar}
\title{Barplot with aggregate and moderator possibilities}
\usage{
plot_bar(fml, data, agg, fun = mean, dict = getFplot_dict(),
  order = FALSE, maxBins = 50, show0 = TRUE, cex.text = 0.7,
  isDistribution = FALSE, yaxis.show = TRUE, labels.tilted,
  trunc = 20, trunc.method = "auto", max_line, hgrid = TRUE,
  onTop = "nb", showOther = TRUE, inCol = "#386CB0",
  outCol = "white", xlab, ylab, ...)
}
\arguments{
\item{fml}{A formula of the form: \code{var ~ agg} with \code{var} the variable, \code{agg} the variable over which to aggregate that will appear in the x-axis.}

\item{data}{A data.frame containing all the variables in the formula argument.}

\item{agg}{In the case \code{fml} is a vector, \code{agg} can be a vector of values over which to aggregate the main variable.}

\item{fun}{A function for the aggregation. Default is \code{mean}.}

\item{dict}{A dictionnary to rename the variables names in the axes and legend. Should be a named vector. By default it s the value of \code{getFplot_dict()}, which you can set with the function \code{\link[fplot]{setFplot_dict}}.}

\item{order}{Defaults to \code{FALSE}. Should the data be ordered w.r.t. frequency?}

\item{maxBins}{Defaults to 50. All other information that does not fit is put into the bin \dQuote{other}.}

\item{show0}{Default to \code{FALSE}. Should the 0 be kept? By default, all the 0s are dropped.}

\item{cex.text}{The size of the text appearing on the top of the bins. Defaults to 0.7.}

\item{isDistribution}{Defaults to \code{FALSE}. It impacts the y-axis display. If it's a distribution, then percentages are shown on the y-axis.}

\item{yaxis.show}{Defaults to \code{FALSE}. Should the y-axis labels be displayed?}

\item{labels.tilted}{Whether there should be tilted labels. Default is \code{FALSE} except when the data is split by moderators (see \code{mod.method}).}

\item{trunc}{If the main variable is a character, its values are truncaded to \code{trunc} characters. Default is 20. You can set the truncation method with the argument \code{trunc.method}.}

\item{trunc.method}{If the elements of the x-axis need to be truncated, this is the truncation method. It can be "auto", "trimRight" or "trimRight".}

\item{max_line}{Integer, default is 1. By defaults the labels of the x-axis can be displayed on several lines (from -1 to 1). This arguments says how far can the algorithm for the placement of the labels go downwards in the x-axis region.}

\item{hgrid}{Default \code{TRUE}. Should the horizontal grid be displayed?}

\item{onTop}{What to display on the top of the bars. Can be equal to "frac" (for shares), "nb" or "none". The default depends on the type of the plot.}

\item{showOther}{Default is \code{TRUE}. In the case the number of bins is lower than the number of cases, should the remaining obervations be displayed by a bar?}

\item{inCol}{Color of the interior of the bars. Default to blue.}

\item{outCol}{Color of the border of the bars. Defatult is black.}

\item{xlab}{The x-axis labels. By default it is the name of the aggregating variable.}

\item{ylab}{The y-axis labels. By default it is the name of the x variable combined with the function applied to it.}

\item{...}{Other arguments to be passed to \code{barplot}.}
}
\value{
Invisibly returns the aggregated data.
}
\description{
This functions draws a barplot in which the variables can have been aggregated beforehand.
}
\examples{

plot_bar(Sepal.Length~Species, iris)

plot_bar(Sepal.Length~Species, iris, fun = var, labels.tilted = TRUE)



}
\author{
Laurent Berge
}
