# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Perform the E step calculations
#'
#' This is an inner wrapper for the C++ functions which perform the E step and is not intended to be used directly.
#' This function does not check the input.
#' For a data set with \code{K} clusters,
#' @param c Vector of length \code{K} of cumulative hazards, i.e. total accumulated hazards within a cluster
#' @param c_lt Vector of length \code{K} of cumulative hazard from 0 to the left truncation time
#' @param delta Vector of integers of length \code{K} of the number of events for each cluster
#' @param alpha,bbeta Parameters of the frailty distribution
#' @param pvfm Parameter for the PVF distribution, only matters in that case
#' @param dist One of 0 (for gamma), 1 (for stable) or 2 (for PVF)
#'
#' @return A \code{K x 3} matrix where the first column and the second column are the numerators
#' and the denominators of the frailty fraction (without the Laplace transform) and the
#' last column is the log(denominator) + log-Laplace transform, i.e. the log-likelihood contribution
#' @importFrom Rcpp evalCpp
#' @keywords internal
Estep <- function(c, c_lt, delta, alpha, bbeta, pvfm, dist) {
    .Call(`_frailtyEM_Estep`, c, c_lt, delta, alpha, bbeta, pvfm, dist)
}

inf_mat_match <- function(left, right, elp, maxlength) {
    .Call(`_frailtyEM_inf_mat_match`, left, right, elp, maxlength)
}

sumxxt <- function(x, L) {
    .Call(`_frailtyEM_sumxxt`, x, L)
}

