% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.jointSurroPenalloocv.R
\name{plot.jointSurroPenalloocv}
\alias{plot.jointSurroPenalloocv}
\title{Plot of leave-one-out crossvalidation Outputs from the one-step Joint surrogate model for evaluating a 
canditate surrogate endpoint.}
\usage{
\method{plot}{jointSurroPenalloocv}(x, unusedtrial = NULL, xleg = "bottomleft", 
yleg = NULL, main = NULL, ...)
}
\arguments{
\item{x}{An object inherent from the \code{jointSurroPenalloocv} Class}

\item{unusedtrial}{Vector of unconsidered trials, may be due to the fact that the 
predicted treatment effects on true endpoint have an outlier. In this case, 
one can drop from the data the trials with very hight absolute predicted value}

\item{xleg}{X-coordinate for the location of the legend}

\item{yleg}{Y-coordinate for the location of the legend, the default is \code{NULL}}

\item{main}{The desired main}

\item{...}{other unused arguments.}
}
\value{
This function displays the boxplots corresponding to the number of trials in the 
dataset. Each boxplot includes 3 elements correnponding to the predicted treatment effect on true endpoint
with the prediction interval. The circle inside or outside the boxplot represents the observed
treatment effect on true endpoint. For all trials with convergence issues or outliers, the boxplot is just represented
by a dash. In the last case, we display in the main of the figure a vector of these trials, if argument \code{main} 
is set to \code{NULL}. The function returns the list of unused trials.
}
\description{
{
Plot of leave-one-out crossvalidation Outputs for evaluating the joint surrogate model 
}
}
\examples{


\dontrun{
library(frailtypack)
data(dataOvarian)

joint.surro.Gumbel <- jointSurroCopPenal(data = dataOvarian, int.method = 0, 
                      n.knots = 8, maxit=50, kappa.use = 4, nb.mc = 1000, 
                      typecopula = 2, print.iter = T, scale = 1/365)
summary(joint.surro.Gumbel)

loocv.result <- loocv(joint.surro.Gumbel)
loocv.result

plot(x = loocv.result, unusedtrial = c(22, 30, 33, 38, 42, 47, 49), 
                          xleg = "bottomleft", y = NULL)
}

}
\references{
Burzykowski T, Buyse M (2006). "Surrogate threshold effect: an alternative 
measure for meta-analytic surrogate endpoint validation." Pharmaceutical 
Statistics, 5(3), 173-186.ISSN 1539-1612.
}
\seealso{
\code{\link{loocv}}
}
\author{
Casimir Ledoux Sofeu \email{casimir.sofeu@u-bordeaux.fr}, \email{scl.ledoux@gmail.com} and 
Virginie Rondeau \email{virginie.rondeau@inserm.fr}
}
\keyword{loocv}
\keyword{plot}
\keyword{prediction}
\keyword{surrogate}
