% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surface_dist.R
\name{closest.vert.to.point}
\alias{closest.vert.to.point}
\title{Find vertex index closest to given query coordinate using Euclidean distance.}
\usage{
closest.vert.to.point(surface, point_coords)
}
\arguments{
\item{surface}{an fs.surface instance or a nx3 numerical matrix representing mesh points.}

\item{point_coords}{nx3 matrix of query coords. If a vector, will be transformed \code{byrow} to such a matrix.}
}
\value{
named list with entries: 'vertex_id' integer vector, the index of the closest vertex, and 'dist': double vector, the Euclidean distance to that vertex.
}
\description{
Find vertex index closest to given query coordinate using Euclidean distance.
}
\seealso{
Other Euclidean distance util functions: 
\code{\link{vertex.euclid.dist}()},
\code{\link{vertexdists.to.point}()}
}
\concept{Euclidean distance util functions}
