% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_surface.R
\name{write.fs.surface}
\alias{write.fs.surface}
\title{Write mesh to file in FreeSurfer surface format}
\usage{
write.fs.surface(filepath, vertex_coords, faces)
}
\arguments{
\item{filepath, }{string. Full path to the output curv file. If it ends with ".gz", the file is written in gzipped format. Note that this is not common, and that other software may not handle this transparently.}

\item{vertex_coords, }{n x 3 matrix of doubles. Each row defined the x,y,z coords for a vertex.}

\item{faces, }{n x 3 matrix of integers. Each row defined the 3 vertex indices that make up the face. WARNING: Vertex indices should be given in R-style, i.e., the index of the first vertex is 1. However, they will be written in FreeSurfer style, i.e., all indices will have 1 substracted, so that the index of the first vertex will be zero.}
}
\value{
string, the format that was written. One of "tris" or "quads". Currently only triangular meshes are supported, so always 'tris'.
}
\description{
Write vertex coordinates and vertex indices defining faces to a file in FreeSurfer binary surface format.
   For a subject (MRI image pre-processed with FreeSurfer) named 'bert', an example file would be 'bert/surf/lh.white'.
}
\seealso{
Other mesh functions: \code{\link{read.fs.surface}}
}
\concept{mesh functions}
