% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cov.structure.R
\name{cov.structure}
\alias{cov.structure}
\title{Estimate the covariance structure within a given window \eqn{k \in [-q,q]}}
\usage{
cov.structure(X, Y = NULL, q = 10)
}
\arguments{
\item{X}{first process}

\item{Y}{second process, if null then autocovariance of \code{X} is computed}

\item{q}{size of the window (covariances from \code{-q} to \code{q} will be computed)}
}
\value{
a time domain operator
}
\description{
Given two multivariate time series \eqn{X_t} and \eqn{Y_t}
estimates the covariances of \eqn{Cov(X_{k} Y_0)} for \eqn{k \in [-q,q]}.
\code{\link{lagged.cov}} is used for the estimation at each lag.
}
\examples{
X = rar(100)
Y = rar(100)
cov.structure(X,Y)
}

