% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_vars_template.R
\name{vars_file}
\alias{vars_file}
\title{SCSS variables from a file}
\usage{
vars_file(input_file)
}
\arguments{
\item{input_file}{Path to SCSS file containing variables to use for creating a theme.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
SCSS variables from a file
}
\examples{
\donttest{
# Open template and edit variables
use_vars_template(
  output_file = "custom.scss",
  theme = "flatly"
)

# Create new theme based on the modified template
create_theme(
  theme = "flatly",
  vars_file(input_file = "custom.scss"),
  output_file = "mytheme.css"
)

}
}
