% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_schema.R
\name{create_schema}
\alias{create_schema}
\title{Create a Table Schema for a data frame}
\usage{
create_schema(data)
}
\arguments{
\item{data}{A data frame.}
}
\value{
List describing a Table Schema.
}
\description{
Creates a Table Schema for a data frame, listing all column names and types
as field names and (converted) types.
}
\details{
See \code{vignette("table-schema")} to learn how this function implements the
Data Package standard.
}
\examples{
# Create a data frame
df <- data.frame(
  id = c(as.integer(1), as.integer(2)),
  timestamp = c(
    as.POSIXct("2020-03-01 12:00:00", tz = "EET"),
    as.POSIXct("2020-03-01 18:45:00", tz = "EET")
  ),
  life_stage = factor(c("adult", "adult"), levels = c("adult", "juvenile"))
)

# Create a Table Schema from the data frame
schema <- create_schema(df)
str(schema)
}
\seealso{
Other create functions: 
\code{\link{create_package}()}
}
\concept{create functions}
