% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tictocify.R
\name{tictocify}
\alias{tictocify}
\title{Creates a function that functions identically to the original, but gives execution time}
\usage{
tictocify(..f, tic_args = NULL, toc_args = NULL)
}
\arguments{
\item{..f}{Any function that isn't primitive (sum, list, etc...)}

\item{tic_args}{A list of arguments to be passed into tic()}

\item{toc_args}{A list of arguments to be passed into toc()}
}
\value{
function
}
\description{
Takes any function and returns a function that will behave in a nearly identical
manner, but will also return the function's execution time.
}
\details{
Creates a wrapper function around a function call, preceded by tic() and
 toc(). The wrapper will be given the same arguments as the original function and
 work identically to the original function.
}
\examples{

set.seed(1)
stuff <- rnorm(n = 100000)

lapply_new <- tictocify(lapply)
lapply_new(stuff, function(x) x > 0)
is.output.same(lapply_new(stuff, function(x) x > 0), lapply)

}
\seealso{
\code{\link{is.output.same}}
}
