% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_umlauts_to_ascii.R
\name{convert_umlauts_to_ascii}
\alias{convert_umlauts_to_ascii}
\alias{convert_umlauts_to_ascii.character}
\alias{convert_umlauts_to_ascii.data.frame}
\title{Convert German Umlauts to a More or Less Suitable `ascii` Representation}
\usage{
convert_umlauts_to_ascii(x)

\method{convert_umlauts_to_ascii}{character}(x)

\method{convert_umlauts_to_ascii}{data.frame}(x)
}
\arguments{
\item{x}{A string or \code{data.frame}.}
}
\value{
\bold{x} with the umlauts converted to ascii.
}
\description{
Convert German Umlauts to a More or Less Suitable `ascii` Representation
}
\examples{
string <- paste("this is \u00e4 string")
print(string)
print(convert_umlauts_to_ascii(string))
string <- paste("this is \u00e4 string")
df <- data.frame(v1 = c(string, "foobar"),
                 v2 = c("foobar", string), v3 = 3:4)
names(df)[3] <- "y\u00dfy"
convert_umlauts_to_ascii(df)
}
\seealso{
Other German umlaut converters: 
\code{\link{convert_umlauts_to_tex}()}
}
\concept{German umlaut converters}
