% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runsed.R
\name{runsed}
\alias{runsed}
\title{Replace a Pattern in Files with a Replacement String}
\usage{
runsed(files, pattern, replacement)
}
\arguments{
\item{files}{A list of file names in which to replace.}

\item{pattern}{A regex pattern, see \code{\link{gsub}}.}

\item{replacement}{A string, see \code{\link{gsub}}.}
}
\value{
\code{\link[base:invisible]{Invisibly}} the vector of names of files
changed.
}
\description{
This function mimics the \command{runsed} script published in \cite{Unix
Power Tools}.
}
\examples{
source_files <- list.files(system.file(package = "fritools", "source", "R"),
                           pattern = ".*\\\\.R$", full.names = TRUE)
file.copy(source_files, tempdir(), overwrite = TRUE)
files <- find_files(file_names = file.path(tempdir(),
                                           basename(source_files)))
print(f <- runsed(files, pattern = "_clean", replacement = "_cleanr"))
print(f <- runsed(files, pattern = "_cleanr\\\\>", replacement = "_cleaner"))
}
\references{
\cite{
  Shelley Powers, Jerry Peek, Tim O'Reilly and Mike Loukides, 2002,
  Unix Power Tools,
  3rd edition,
  O'Reilly Media, Inc.
}
}
\seealso{
Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_blank_lines}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{find_files}()},
\code{\link{get_lines_between_tags}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{grep_file}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{search_files}()},
\code{\link{split_code_file}()},
\code{\link{touch}()}

Other searching functions: 
\code{\link{compare_vectors}()},
\code{\link{file_modified_last}()},
\code{\link{find_files}()},
\code{\link{fromto}()},
\code{\link{grep_file}()},
\code{\link{missing_docs}},
\code{\link{search_files}()},
\code{\link{search_rows}()},
\code{\link{summary.filesearch}()}
}
\concept{file utilities}
\concept{searching functions}
