% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{path_math}
\alias{path_math}
\alias{path_real}
\alias{path_split}
\alias{path_join}
\alias{path_abs}
\alias{path_norm}
\alias{path_rel}
\alias{path_common}
\title{Path computations}
\usage{
path_real(path)

path_split(path)

path_join(parts)

path_abs(path)

path_norm(path)

path_rel(path, start = ".")

path_common(path)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{parts}{A list of character vectors, corresponding to split paths.}

\item{start}{A starting directory to compute relative path to.}
}
\value{
The new path as a character vector. For \code{\link[=path_split]{path_split()}}, a list of
character vectors of path components is returned instead.
}
\description{
All functions apart from \code{\link[=path_expand]{path_expand()}} and \code{\link[=path_real]{path_real()}} are purely
path computations, so the files in question do not need to exist on the
filesystem.
}
\section{Functions}{
\itemize{
\item \code{path_real}: returns the canonical path, eliminating any symbolic
links.

\item \code{path_split}: splits paths into parts.

\item \code{path_join}: joins parts together. The inverse of \code{\link[=path_split]{path_split()}}.
See \code{\link[=path]{path()}} to concatenate vectorized strings into a path.

\item \code{path_abs}: returns a normalized, absolute version of a path.

\item \code{path_norm}: collapses redundant separators and
up-level references, so \code{A//B}, \code{A/B}, \code{A/.B} and \code{A/foo/../B} all become
\code{A/B}. If one of the paths is a symbolic link, this may change the meaning
of the path, in this case one should use \code{\link[=path_real]{path_real()}} prior to calling
\code{\link[=path_norm]{path_norm()}}.

\item \code{path_rel}: computes the path relative to the \code{start} path,
which can be either a absolute or relative path.

\item \code{path_common}: finds the common parts of two (or more) paths.
}}

\examples{
\dontshow{.old_wd <- setwd(tempdir())}
# Expand a path
path_expand("~/bin")

dir_create("a")
file_create("a/b")
link_create(path_abs("a"), "c")

# Realize the path
path_real("c/b")

# Split a path
parts <- path_split("a/b")
parts

# Join it together
path_join(parts)

# Find the absolute path
path_abs("..")

# Normalize a path
path_norm("a/../b\\\\c/.")

# Compute a relative path
path_rel("/foo/abc", "/foo/bar/baz")

# Find the common path between multiple paths
path_common(c("/foo/bar/baz", "/foo/bar/abc", "/foo/xyz/123"))

# Cleanup
dir_delete("a")
link_delete("c")
\dontshow{setwd(.old_wd)}
}
