% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph_concat.R
\name{group.concat.measures.standard}
\alias{group.concat.measures.standard}
\title{Concatenate standard space data for a group of subjects.}
\usage{
group.concat.measures.standard(subjects_dir, subjects_list, measures, hemi,
  fwhm_per_measure)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subjects_list, }{string vector. A vector of subject identifiers that match the directory names within subjects_dir.}

\item{measures, }{vector of strings. Names of the vertex-wise morhometry measures. E.g., c("area", "thickness"). Used to construct the names of the morphometry file to be loaded. The data of each measure will be one column in the resulting dataframe.}

\item{hemi, }{string, one of 'lh', 'rh' or 'both'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{fwhm_per_measure, }{vector of strings. The fwhm settings to use, for each measure. If this is a string instead of a vector of strings, the same fwhm will be used for all measures.}
}
\value{
dataframe with concatenated vertex values. Each column contains the values for one measure, concatenated for all subjects. The column names are a concatination of the measure, "_fwhm", and the fwhm for that measure. WARNING: This dataframe can get large if you have many subjects.
}
\description{
A measure is something like 'thickness' or 'area'. This function concatenates the standard space data for all subjects into a single long vector for each measure. A dataframe is then created, in which each column is one such vector. This can be used to compute the correlation between measures on vertex level, for example.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   subjects_list = c('subject1', 'subject2');
   cm = group.concat.measures.standard(subjects_dir, subjects_list,
    c("thickness", "area"), "lh", "10");
}

}
\seealso{
Other concatination functions: \code{\link{group.concat.measures.native}}
}
\concept{concatination functions}
