% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export.coloredmesh.ply}
\alias{export.coloredmesh.ply}
\title{Export a coloredmeshes with vertexcolors in PLY format.}
\usage{
export.coloredmesh.ply(filepath, coloredmesh)
}
\arguments{
\item{filepath}{The export filepath, including file name and extension.}

\item{coloredmesh}{an 'fs.coloredmesh' instance, as returned (silently) by all surface visualization functions, like \code{\link[fsbrain]{vis.subject.morph.native}}.}
}
\description{
Exports coloredmeshes with vertex coloring to standard mesh files in Stanford Triangle (PLY) format. This is very hand for rendering in external standard 3D modeling software like \href{http://blender.org}{Blender}.
}
\examples{
\dontrun{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   coloredmeshes = vis.subject.morph.native(subjects_dir, 'subject1', 'thickness');
   export.coloredmesh.ply('~/subject1_thickness_lh.ply', coloredmeshed$lh);
}

}
