% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_io.R
\name{demographics.to.fsgd.file}
\alias{demographics.to.fsgd.file}
\title{Write FreeSurfer Group Descriptor (FSGD) file from demographics dataframe.}
\usage{
demographics.to.fsgd.file(
  filepath,
  demographics_df,
  group_column_name = "group",
  subject_id_column_name = "id",
  var_columns = NULL,
  ftitle = "OSGM",
  fsgd_flag_lines = c("DeMeanFlag 1", "ReScaleFlag 1")
)
}
\arguments{
\item{filepath}{character string, the path to the output file in FSGD format}

\item{demographics_df}{data.frame, as returned by \code{read.md.demographics} or created manually. Note that the data.frame must not contain any character columns, they should be converted to factors.}

\item{group_column_name}{character string, the column name of the group column in the 'demographics_df'}

\item{subject_id_column_name}{character string, the column name of the subject identifier column in the 'demographics_df'}

\item{var_columns}{vector of character strings, the column names to include as variables in the FSGD file. If NULL (the default), all columns will be included (with the exception of the group column and the subject id column).}

\item{ftitle}{character string, freeform title for the FSGD file}

\item{fsgd_flag_lines}{vector of character strings, extra flag lines to write to the file. The default setting will activate de-meaning and rescaling.}
}
\value{
vector of character strings, the lines written to the 'filepath', invisible.
}
\description{
Write FreeSurfer Group Descriptor (FSGD) file from demographics dataframe.
}
\seealso{
Other metadata functions: 
\code{\link{read.md.demographics}()},
\code{\link{read.md.subjects}()},
\code{\link{report.on.demographics}()}
}
\concept{metadata functions}
