% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rglactions.R
\name{clip.data}
\alias{clip.data}
\title{Clip data at quantiles to remove outliers.}
\usage{
clip.data(data, lower = 0.05, upper = 0.95)
}
\arguments{
\item{data, }{numeric vector. The input data. Can also be a hemi list.}

\item{lower, }{numeric. The probability for the lower quantile, defaults to `0.05`.}

\item{upper, }{numeric. The probability for the upper quantile, defaults to `0.95`.}
}
\value{
numeric vector. The output data.
}
\description{
Set all data values outside the given quantile range to the border values. This is usefull to properly visualize morphometry data that includes outliers. These outliers negatively affect the colormap, as all the non-outlier values become hard to distinguish. This function can be used to filter the data before plotting it.
}
\examples{
   full_data = rnorm(50, 3, 1);
   clipped = clip.data(full_data);

}
