% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hemilist.R
\name{hemilist}
\alias{hemilist}
\title{Create a hemilist from lh and rh data.}
\usage{
hemilist(lh_data = NULL, rh_data = NULL)
}
\arguments{
\item{lh_data}{something to wrap, typically some data for a hemisphere, e.g., a vector of morphometry data values.}

\item{rh_data}{something to wrap, typically some data for a hemisphere, e.g., a vector of morphometry data values.}
}
\value{
named list, with the 'lh_data' in the 'lh' key and the 'rh_data' in the 'rh' key.
}
\description{
Simply runs \code{list('lh' = lh_data, 'rh' = rh_data)}: A hemilist (short for hemisphere list) is just a named list with entries 'lh' and/or 'rh', which may contain anything. Hemilists are used as parameters and return values in many \code{fsbrain} functions. The 'lh' and 'rh' keys typically contain surfaces or vectors of morphometry data.
}
\examples{
  lh_data = rnorm(163842, 5.0, 1.0);
  rh_data = rnorm(163842, 5.0, 1.0);
  hl = hemilist(lh_data, rh_data);

}
\seealso{
Other hemilist functions: 
\code{\link{hemilist.derive.hemi}()},
\code{\link{hemilist.get.combined.data}()},
\code{\link{hemilist.unwrap}()},
\code{\link{hemilist.wrap}()},
\code{\link{is.hemilist}()}
}
\concept{hemilist functions}
