% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_multiview.R
\name{shift.hemis.apart}
\alias{shift.hemis.apart}
\title{Shift hemispheres apart.}
\usage{
shift.hemis.apart(
  coloredmeshes_hl,
  shift_by = NULL,
  axis = 1L,
  hemi_order_on_axis = "lr",
  min_dist = 0
)
}
\arguments{
\item{coloredmeshes_hl}{hemilist of coloredmeshes}

\item{shift_by}{numerical vector of length 2, the amount by which to shift the hemis. The first value is for the left hemi, the second for the right hemi (values can be negative). Pass `NULL` to determine the shift automatically from the mesh coordinates, and adapt 'hemi_order_on_axis' to define how that happens.}

\item{axis}{positive integer, one of 1L, 2L or 3L. The axis on which to shift (x,y,z).}

\item{hemi_order_on_axis}{character string, one of 'auto', 'auto_flipped', 'lr' or 'rl'. Defines how to determine the order of the hemis on the axes. This is ignored unless 'shift_by' is `NULL`. The 'auto' setting assumes that the hemisphere with the smaller minimal vertex coordinate (on the given axis) comes first. Note that if the overlap (or shift) is extreme, this may not hold anymore. Therefore, the default value is 'lr', which works for FreeSurfer data. The 'auto_flipped' setting will always return the inverse of 'auto', so if 'auto' did not work, 'auto_flipped' will.}

\item{min_dist}{numerical scalar, the minimal distance of the hemispheres. Ignored unless 'shift_by' is `NULL`.}
}
\value{
hemilist of coloredmeshes, the shifted meshes
}
\description{
Modify mesh coordinates of a hemilist of coloredmeshes to introduce a gap between the two hemispheres.
}
