% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodesic.R
\name{subject.descriptor.geodesic.average.distance}
\alias{subject.descriptor.geodesic.average.distance}
\title{Compute mean geodesic distance descriptor for a subject.}
\usage{
subject.descriptor.geodesic.average.distance(
  subjects_dir,
  subject_id,
  surface = "white",
  hemi = "both",
  ...
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier.}

\item{surface}{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{hemi}{string, one of 'lh', 'rh', or 'both'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{...}{extra parameters passed on to \code{geodesic.average.distance}. Ignored if 'cortex_only' is TRUE.}
}
\value{
a \code{\link[fsbrain]{hemilist}} containing vectors with the descriptor data for the requested hemisphere(s). The length of the vectors is the number of vertices in the surface, and the value for a vertex is the mean geodesic distance to all other vertices for this vertex.
}
\description{
For all vertices: compute the mean pseudo-geodesic distance from this vertex to all others in the same hemisphere. Computes \code{|V|^2} geodesic distances.
}
\note{
This takes quite a while for full-resolution meshes. Use down-sampled versions to quickly try it (see example).
}
\examples{
\dontrun{
  download_fsaverage3(TRUE);
  sjd = fsaverage.path();
  dist = subject.descriptor.geodesic.average.distance(sjd,
    "fsaverage3", surface = "white", hemi = "both");
  vis.data.on.subject(sjd, "fsaverage3", morph_data_lh = dist$lh);
}

}
\keyword{internal}
