% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{surf.avg.vertexradius}
\alias{surf.avg.vertexradius}
\title{Compute average distance from the origin to each vertex.}
\usage{
surf.avg.vertexradius(surface, with_stddev = FALSE)
}
\arguments{
\item{surface}{an fs.surface instance, and for the typical use case of this function, a spherical surface.}

\item{with_stddev}{logical, whether to compute the standard deviation as well and return a named list with the 'avg' and the 'stddev' instead.}
}
\value{
scalar double, the average distance.
}
\description{
Compute average distance from the origin to each vertex.
}
\note{
This is used to determine the sphere radius for spherical surfaces. It is assumed that the sphere is centered at the origin \code{(0,0,0)}.
}
\examples{
\dontrun{
spherical_surface = subject.surface(fsaverage.path(), "fsaverage3",
  surface="sphere", hemi="lh");
vr = fsbrain:::surf.avg.vertexradius(spherical_surface);
# Show histogram to verify that the surface is a sphere centered at 0,0,0:
hist(freesurferformats::vertexdists.to.point(spherical_surface, c(0,0,0)));
# Plot the coords and a point at the origin:
fsbrain::highlight.points.spheres(rbind(spherical_surface$vertices, c(0,0,0)));
}

}
\keyword{internal}
