% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{metadata_fst}
\alias{metadata_fst}
\alias{fst.metadata}
\title{Read metadata from a fst file}
\usage{
metadata_fst(path, old_format = FALSE)

fst.metadata(path, old_format = FALSE)
}
\arguments{
\item{path}{path to fst file}

\item{old_format}{must be FALSE, the old fst file format is deprecated and can only be read and
converted with fst package versions 0.8.0 to 0.8.10.}
}
\value{
Returns a list with meta information on the stored dataset in \code{path}.
Has class \code{fstmetadata}.
}
\description{
Method for checking basic properties of the dataset stored in \code{path}.
}
\examples{
# Sample dataset
x <- data.frame(
  First = 1:10,
  Second = sample(c(TRUE, FALSE, NA), 10, replace = TRUE),
  Last = sample(LETTERS, 10))

# Write to fst file
fst_file <- tempfile(fileext = ".fst")
write_fst(x, fst_file)

# Display meta information
metadata_fst(fst_file)
}
