% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colformat.R
\name{colformat_md}
\alias{colformat_md}
\title{Format character columns as markdown text}
\usage{
colformat_md(
  x,
  j = where(is.character),
  auto_color_link = "blue",
  .from = "markdown+autolink_bare_uris"
)
}
\arguments{
\item{x}{A \code{flextable} object}

\item{j}{Columns to be treated as markdown texts.
Selection can be done by the semantics of \code{dplyr::select()}.}

\item{auto_color_link}{A color of the link texts.}

\item{.from}{Pandoc's \code{--from} argument (default: \code{'markdown+autolink_bare_uris'}).}
}
\description{
Format character columns as markdown text
}
\examples{
if (rmarkdown::pandoc_available()) {
  d <- data.frame(
    x = c("**bold**", "*italic*"),
    y = c("^superscript^", "~subscript~"),
    z = c("***^ft^~Extra~** is*", "*Cool*")
  )
  colformat_md(flextable::flextable(d))
}
}
