% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENUComposition.R
\name{ENUComposition}
\alias{ENUComposition}
\title{Enhanced nucleotide Composition}
\usage{
ENUComposition(
  seqs,
  winSize = 20,
  overLap = TRUE,
  outFormat = "mat",
  outputFileDist = "",
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{winSize}{is a number which shows the size of the window.}

\item{overLap}{This parameter shows how the window
moves on the sequence. If the overlap is set to TRUE, the next window would have distance 1 with
the previous window. Otherwise, the next window will start from the next amino acid after the previous window.
There is no overlap between the next and previous windows.}

\item{outFormat}{(output format) can take two values: 'mat'(matrix) and 'txt'. The default value is 'mat'.}

\item{outputFileDist}{shows the path and name of the 'txt' output file.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
The output depends on the outFormat parameter which can be either 'mat' or 'txt'. If outFormat is 'mat', the function returns a feature
matrix for sequences with the same length such that the number of columns is (4 * number of partitions displayed by the window)
and the number of rows is equal to the number of sequences. It is usable for machine learning purposes.
If the outFormat is 'txt', the output is written to a tab-delimited file.
}
\description{
This function slides a window over the input sequence(s).
Also, it computes the composition of nucleotides that appears within the limits of the window.
Please note that when a feature vector of sequences is given as the input, their length should be equal.
Otherwise, either an error (in case the outFortmat is 'mat') or a text file (when the outFortmat is 'txt') is returned.
Please note that the text file is not suitable for machine learning purposes.
}
\note{
When overlap is FALSE, the last partition represented by the window may have a different length with other parts.
}
\examples{

dir = tempdir()
LNCSeqsADR<-system.file("extdata/",package="ftrCOOL")
LNC50Nuc<-as.vector(read.csv(paste0(LNCSeqsADR,"/LNC50Nuc.csv"))[,2])
mat<-ENUComposition(seqs = LNC50Nuc, winSize=20,outFormat="mat")

ad<-paste0(dir,"/ENUCcompos.txt")
fileLNC<-system.file("extdata/Athaliana_LNCRNA.fa",package="ftrCOOL")
ENUComposition(seqs = fileLNC,outFormat="txt",winSize=20
,outputFileDist=ad,overLap=FALSE)
}
