% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonStandardSeq.R
\name{nonStandardSeq}
\alias{nonStandardSeq}
\title{nonStandard sequence (nonStandardSeq)}
\usage{
nonStandardSeq(file, legacy.mode = TRUE, seqonly = FALSE, alphabet = "aa")
}
\arguments{
\item{file}{The address of fasta file which contains all the sequences.}

\item{legacy.mode}{It comments all lines starting with ";"}

\item{seqonly}{If it is set to true, the function returns sequences with no description.}

\item{alphabet}{It is a vector which contains the amino acid, RNA, or DNA alphabets.}
}
\value{
This function returns a string vector. Each element of the vector is a sequence which contains
at least one non-standard alphabet.
}
\description{
This function returns sequences which contain at least one non-standard alphabet.
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
nonStandardPrSeq<-nonStandardSeq(file = filePrs,alphabet="aa")

fileLNC<-system.file("extdata/Athaliana_LNCRNA.fa",package="ftrCOOL")
nonStandardNUCSeq<-nonStandardSeq(file = filePrs, alphabet="dna")
}
