% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_plottingFunctions.R
\name{plotEvol-generic}
\alias{plotEvol-generic}
\title{Plot for the evolution of model selection algorithm}
\arguments{
\item{x.model}{an object containing the data structures returned by the model selection algorithm.}

\item{...}{additional arguments affecting the plot.}
}
\value{
None.
}
\description{
This method displays the evolution of an iterative algorithm for model selection.
}
\examples{
require(funGp) # a package with a plotEvol method implemented

# generating input and output data
set.seed(100)
n.tr <- 2^5
sIn <- expand.grid(x1 = seq(0,1,length = n.tr^(1/5)), x2 = seq(0,1,length = n.tr^(1/5)),
                   x3 = seq(0,1,length = n.tr^(1/5)), x4 = seq(0,1,length = n.tr^(1/5)),
                   x5 = seq(0,1,length = n.tr^(1/5)))
fIn <- list(f1 = matrix(runif(n.tr*10), ncol = 10), f2 = matrix(runif(n.tr*22), ncol = 22))
sOut <- fgp_BB7(sIn, fIn, n.tr)
\donttest{
# optimizing the model structure with fgpm_factory (~5 seconds)
xm <- fgpm_factory(sIn = sIn, fIn = fIn, sOut = sOut)

# assessing the evolution of the algorihtm
plotEvol(xm)
}

}
\seealso{
\strong{*} \link[funGp]{plotEvol} for a plot on the evolution of the model selection algorithm
  in fgpm_factory.
}
