% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simul_data}
\alias{simul_data}
\title{Simulation of trajectories from two samples diverging by a delta function}
\usage{
simul_data(
  n_point,
  n_obs1,
  n_obs2,
  c_val = 0,
  delta_shape = "constant",
  distrib = "normal",
  max_iter = 10000
)
}
\arguments{
\item{n_point}{integer value, number of points in the trajectory.}

\item{n_obs1}{integer value, number of trajectories in the first sample.}

\item{n_obs2}{integer value, number of trajectories in the second sample.}

\item{c_val}{numeric value, level of divergence between the two samples.}

\item{delta_shape}{character string, shape of the divergence between the
two samples, among \code{"constant"}, \code{"linear"}, \code{"quadratic"}.}

\item{distrib}{character string, type of probability distribution used to
simulate the data among \code{"normal"}, \code{"cauchy"}, \code{"dexp"}, \code{"student"}.}

\item{max_iter}{integer, maximum number of iteration for the iterative
simulation process.}
}
\value{
A list with the following elements
\itemize{
\item \code{mat_sample1}: numeric matrix of dimension \verb{n_point x n_obs1} containing
\code{n_obs1} trajectories (in columns) of size \code{n_point} (in rows)
corresponding to sample 1.
\item \code{mat_sample2}: numeric matrix of dimension \verb{n_point x n_obs2} containing
\code{n_obs2} trajectories (in columns) of size \code{n_point} (in rows)
corresponding to sample 2.
}
}
\description{
Simulate \code{n_obs1} trajectories of length \code{n_point} in the first sample and
\code{n_obs2} trajectories of length \code{n_point} in the second sample.
}
\examples{
simu_data <- simul_data(
    n_point = 100, n_obs1 = 50, n_obs2 = 75, c_val = 10, 
    delta_shape = "constant", distrib = "normal"
)
str(simu_data)
}
\references{
Zaineb Smida, Lionel Cucala, Ali Gannoun & Ghislain Durif (2022)
A median test for functional data, Journal of Nonparametric Statistics,
34:2, 520-553,
\doi{10.1080/10485252.2022.2064997},
\href{https://hal.science/hal-03658578}{hal-03658578}
}
\seealso{
\code{\link[=plot_simu]{plot_simu()}}, \code{\link[=simul_traj]{simul_traj()}}
}
