% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{cbind_mfd}
\alias{cbind_mfd}
\title{Bind variables of two Multivariate Functional Data Objects}
\usage{
cbind_mfd(mfdobj1, mfdobj2)
}
\arguments{
\item{mfdobj1}{An object of class mfd, with the same number of replications of mfdobj2
and different variable names with respect to mfdobj2.}

\item{mfdobj2}{An object of class mfd, with the same number of replications of mfdobj1,
and different variable names with respect to mfdobj1.}
}
\value{
An object of class mfd, whose replications are the same of mfdobj1 and
mfdobj2 and whose functional variables are the union of the functional
variables in mfdobj1 and mfdobj2.
}
\description{
Bind variables of two Multivariate Functional Data Objects
}
\examples{
library(funcharts)
mfdobj1 <- data_sim_mfd(nvar = 3, seed = 1)
mfdobj2 <- data_sim_mfd(nvar = 2, seed = 2)
dimnames(mfdobj2$coefs)[[3]] <- mfdobj2$fdnames[[3]] <- c("var10", "var11")

plot_mfd(mfdobj1)
plot_mfd(mfdobj2)
mfdobj_cbind <- cbind_mfd(mfdobj1, mfdobj2)
plot_mfd(mfdobj_cbind)

}
