% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelling.R
\name{affect_motifs}
\alias{affect_motifs}
\title{Label assemblages by assembly motif}
\usage{
affect_motifs(affectElt, mOccur)
}
\arguments{
\item{affectElt}{a vector of integers.
The vector contains the labels of the different functional groups
to which each component belongs.
Each functional group is labelled as an integer.}

\item{mOccur}{a matrix of occurrence (occurrence of components).
Its first dimension equals to \code{length(fct)}.
 Its second dimension
 equals to the number of components.}
}
\value{
Return a vector of labels, of \code{dim(mOccur)[2]}.
}
\description{
Take a vector of affectation of components
by functional groups,
then build the different assembly motifs
generated by combining the different functional groups,
finally label the assemblages
that belong to the same assembly motifs.
The labels are integers.
}
\details{
A set of \code{s} components generates
\code{m = 2^s - 1} assembly motifs.
The function only looks for existing, observed assembly motifs.
Each assembly motif is labelled from \code{1} to \code{m},
with \code{m <= s}.
The assembly motifs are first sorted by size (number of clusters),
then labelled gradually:
the first motif identified is labelled \code{1},
the second motif identified is labelled \code{2}, etc...
The number of observed assembly motifs is lower or equal to \code{m}.
}
\keyword{internal}
