% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{plot_fperf}
\alias{plot_fperf}
\title{Plot modelled and predicted performances
 resulting from functional clustering}
\usage{
plot_fperf(fres, nbcl = 0, main = "Title", opt.perf = NULL )
}
\arguments{
\item{fres}{an object generated by the function \code{\link{fclust}}.}

\item{nbcl}{an integer.
The integer indicates the number of component clusters
to take into account.
It can be lower than or equals to
the optimum number \code{fres$nbOpt} of component clusters.}

\item{main}{a string, that is used
as the first, reference part of the title of each graph.}

\item{opt.perf}{a list, that can include
\code{opt.perf = list("stats_I", "stats_II",
"cal", "prd", "missing", "pub", "calprd",
"seq", "ass", "aov", pvalue, "all")}.
This option list manages the plot
of observed, modelled and predicted performances of assemblages,
and associated statistics. It also allows to plot performances of
some given, identified assemblages.
The item order in list is any. \cr

\itemize{
 \item{\code{"stats_I", "stats_II":}}{  plot the statistics associated to
   fit of primary tree that best accounts
   for observed performances (\code{"stats_I"}),
   and of secondary tree that best predicts
   observed performances of assemblages (\code{"stats_II"}).
   Four graphs are plotted:
   1. coefficient of determination \code{R2}
   and efficiency \code{E} of models of component clustering
   (on y-axis) \emph{versus} the number of component clusters (on x-axis);
   2. the ratio of assemblage perfomances
   that cannot be predicted by cross-validation ("predicting ratio");
   3. and 4. the Akaike Information Criterion,
   corrected \code{AICc} or not \code{AIC} for small datasets.
   The green solid line indicates the first minimum of \code{AIC}
   that corresponds to the optimum number \code{nbOpt}
   of component clusters to consider.
   }

 \item{\code{"cal", "prd":}}{  plot modelled performances
   \emph{versus} observed performances (\code{"cal"},
   or modelled and predicted by cross-validation performances
   \emph{versus} observed performances (\code{"prd"},
   for a number of component clusters increasing from \code{1}
   until the number of component clusters where efficiency \code{E}
   is maximum.
   Different symbols correspond to different assembly motifs.
   The prediction error induced by cross-validation is indicated
   by a short vertical line. \cr

   The blue dashed lines are mean performances.
   The red solid line is 1:1 bissector line.
   The number of component clusters is indicated on graph left top.
   Predicting ratio and coefficient of determination \code{R2}
   of the clustering
   are indicated on graph right bottom.
   If \code{"prd"} is checked, efficiency \code{E}
   and \code{E/R2} ratio are added.
   If \code{"aov"} is checked, groups significantly different
   (at a p-value < \code{pvalue}) are indicated by differents letters
   on the right of graph.
   }

 \item{\code{"missing":}}{  the option \code{"prd"} plot
   modelled and predicted by cross-validation performances
   \emph{versus} observed performances,
   using different symbols for different assembly motifs.
   The option \code{"missing"} plot the same data,
   but in using different symbols according to the clustering model
   used for predicting the performances of assemblages.
   This option allows to identify assemblages
   of which the performance cannot be predicted
   using the clustering model of the current level.
   The assemblages are plotted and named
   using the symbol corresponding to the level
   of the used clustering model. \cr

   The blue dashed lines are mean performances.
   The red solid line is 1:1 bissector line.
   The number of component clusters is indicated on graph left top.
   Predicting ratio and coefficient of determination of the clustering
   are indicated on graph right bottom.
   If \code{"aov"} is checked, groups significantly different
   (at a p-value < \code{pvalue}) are indicated by differents letters
   on the right of graph.
   }

 \item{\code{"pub":}}{  the option \code{"prd"} plot
   modelled and predicted by cross-validation performances
   \emph{versus} observed performances,
   using different symbols for different assembly motifs.
   The option \code{"pub"} plot the same data,
   but in using only one symbol.
   This option is useful for publication. \cr

   The blue dashed lines are mean performances.
   The red solid line is 1:1 bissector line.
   The number of component clusters is indicated on graph left top.
   Predicting ratio and coefficient of determination of the clustering
   are indicated on graph right bottom.
   If \code{"aov"} is checked, groups significantly different
   (at a p-value < \code{pvalue}) are indicated by differents letters
   on the right of graph.
   }

 \item{\code{"calprd":}}{  plot performances predicted by cross-validation
   \emph{versus} performances predicted by clustering model
   ("modelled performances"). This option is useful
   to identify which assembly motifs become difficult
   to predict by cross-validation. \cr

   The blue dashed lines are mean performances.
   The red solid line is 1:1 bissector line.
   The number of component clusters is indicated on graph left top.
   Predicting ratio and coefficient of determination of the clustering
   are indicated on graph right bottom.
   If \code{"aov"} is checked, groups significantly different
   (at a p-value < \code{pvalue}) are indicated by differents letters
   on the right of graph. The letters are located
   at \code{mean(Fprd[motif == label])}.
   }

\item{\code{"seq":}}{  plot performances of assembly motifs,
  from \code{1} to \code{nbMax} number of component clusters.
  Remember that number \code{m} of assembly motifs increases
  with the number \code{nbcl} of component clusters
  (\code{m = 2^nbcl - 1}). When the optimal number
  of component clusters is large,
  this option is useful to determine
  a number of component clusters lower
  than the optimal number of component clusters.
  Assembly motifs are named as the combinations of component clusters
  (see "opt.tree").
  }

 \item{\code{"ass"}}{  plot the name of each assemblage
   close to its performance. This option can be used with
   the options \code{"cal"}, \code{"prd"}, \code{"pub"}
   and \code{"calprd"}. It must be used only
   if the number of assemblages is small.
   If the number of assemblages is large,
   the following option \code{"opt.ass"} is more convenient.
   }

 \item{\code{"aov":}}{  does a variance analysis of assemblage performances
   by assembly motifs, and plot the result on the right of graphs.
   Different letters correspond to
   groups significantly different at a p-value < \code{pvalue}.
   If \code{"aov"} is checked, \code{pvalue} must be informed.
   If not, \code{pvalue = 0.001}.
  }

\item{\code{pvalue:}}{  a probability used as threshold
  in the variance analysis. Then \code{pvalue} must be
  higher than \code{0} and lower than \code{1}.
  \code{pvalue} must be informed when \code{"aov"} is checked.
  Groups significantly different
  (at a p-value < \code{pvalue}) are then indicated by differents letters
  on the right of boxplots.
  }

\item{\code{"all":}}{  plot all possible graphs.
  This option is equivalent to
  \code{opt.pref = list("cal", "prd", "pub", "calprd",
  "aov", pvalue = 0.001)}.
  }
}}
}
\value{
Nothing. It is a procedure.
}
\description{
The function plots
observed, modelled and predicted performances
 resulting from functional clustering
}
\details{
None.
}
\seealso{
\code{\link{plot_ftrees}} plot primary and secondary trees
 resulting from functional clustering \cr
\code{\link{plot_fperf}} plot observed, modelled and predicted performances
 resulting from functional clustering \cr
\code{\link{plot_fass}} plot performances of some given assemblages \cr
\code{\link{plot_fmotif}} plot as boxplot mean performances
of assemblages sorted by assembly motifs \cr
\code{\link{plot_fcomp}} plot as boxplot mean performances
of assemblages containing a given component \cr
\code{\link{fclust_plot}} plot all possible outputs
of functional clustering
}
\keyword{internal}
