% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{test_posthoc}
\alias{test_posthoc}
\title{Test posthoc of variance analysis}
\usage{
test_posthoc(x, clusters, pvalue = fpvalue())
}
\arguments{
\item{x}{a numeric vector.}

\item{clusters}{a vector of factors of \code{length(x)}.}

\item{pvalue}{a marginal p-value.}
}
\value{
Return a \code{data.frame} containing
 the name of the groups \code{motif},
  the group size \code{number},
 the group mean \code{mean} and standard deviation \code{sd},
 and the two-to-two differences expressed
 in the form of letters \code{group}.
}
\description{
Proceed to a variance analysis of the vector of data
\code{x} associated with the vector of factors \code{clusters}. It returns
a \code{data.frame} containing the name of the groups
\code{motif}, the group size \code{number}, the group mean
\code{mean} and standard deviation \code{sd}, and the two-to-two
 differences expressed in the form of letters \code{group}.
}
\details{
The function \code{test_posthoc()} uses Tukey method.
Different groups are sorted by decreasing means.
Letter rank increases with decreasing means.
}
\keyword{internal}
