% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalCor.R
\name{normalCor}
\alias{normalCor}
\title{Compute Normal-Theory Covariances for Correlations}
\usage{
normalCor(R, Nobs)
}
\arguments{
\item{R}{a p x p matrix of correlations.}

\item{Nobs}{Number of observations.}
}
\value{
A normal-theory covariance matrix of correlations.
}
\description{
Compute normal-theory covariances for correlations
}
\examples{

	data(Harman23.cor)
	normalCor(Harman23.cor$cov, Nobs = 305)

}
\references{
Nel, D.G. (1985). A matrix derivation of the asymptotic
covariance matrix of sample correlation coefficients. \emph{Linear algebra
and its applications, 67}, 137--145.
}
\seealso{
\code{\link{adfCor}}
}
\author{
Jeff Jones and Niels Waller
}
\keyword{Statistics}
