% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/futureOf.R
\name{futureOf}
\alias{futureOf}
\title{Get the future of a future variable}
\usage{
futureOf(var = NULL, envir = parent.frame(), mustExist = TRUE,
  default = NA, drop = FALSE)
}
\arguments{
\item{var}{the variable.  If NULL, all futures in the
environment are returned.}

\item{envir}{the environment where to search from.}

\item{mustExist}{If TRUE and the variable does not exists, then
an informative error is thrown, otherwise NA is returned.}

\item{default}{the default value if future was not found.}

\item{drop}{if TRUE and \code{var} is NULL, then returned list
only contains futures, otherwise also \code{default} values.}
}
\value{
A \link{Future} (or \code{default}).
If \code{var} is NULL, then a named list of Future:s are returned.
}
\description{
Get the future of a future variable that has been created directly
or indirectly via \code{\link{future}()}.
}
\examples{
a \%<=\% { 1 }

f <- futureOf(a)
print(f)

b \%<=\% { 2 }

f <- futureOf(b)
print(f)

## All futures
fs <- futureOf()
print(fs)


## Futures part of environment
env <- new.env()
env$c \%<=\% { 3 }

f <- futureOf(env$c)
print(f)

f2 <- futureOf(c, envir=env)
print(f2)

f3 <- futureOf("c", envir=env)
print(f3)

fs <- futureOf(envir=env)
print(fs)



}

