% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eager.R
\name{eager}
\alias{eager}
\alias{transparent}
\title{Create an eager future whose value will be resolved immediately}
\usage{
eager(expr, envir = parent.frame(), substitute = TRUE, globals = TRUE,
  local = TRUE, earlySignal = FALSE, label = NULL, ...)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{envir}{The \link{environment} from where global
objects should be identified.  Depending on "evaluator",
it may also be the environment in which the expression
is evaluated.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{globals}{A logical, a character vector,
or a named list for controlling how globals are handled.
For details, see below section.
This argument can be specified via the \dots arguments
for \code{future()} and \code{futureCall()}.}

\item{local}{If TRUE, the expression is evaluated such that
all assignments are done to local temporary environment, otherwise
the assignments are done in the calling environment.}

\item{earlySignal}{Specified whether conditions should be signaled
as soon as possible or not.}

\item{label}{An optional character string label attached to the future.}

\item{...}{Additional arguments passed to the "evaluator".}
}
\value{
An \link{EagerFuture}.
}
\description{
An eager future is a future that uses eager evaluation, which means
that its \emph{value is computed and resolved immediately}, which is
how regular expressions are evaluated in R.
The only difference to R itself is that globals are validated
by default just as for all other types of futures in this package.
}
\details{
The preferred way to create an eager future is not to call this function
directly, but to register it via \code{\link{plan}(eager)} such that it
becomes the default mechanism for all futures.  After this
\code{\link{future}()} and \code{\link{\%<-\%}} will create
\emph{eager futures}.
}
\section{transparent futures}{

Transparent futures are eager futures configured to emulate how R
evaluates expressions as far as possible.  For instance, errors and
warnings are signaled immediately and assignments are done to the
calling environment (without \code{local()} as default for all other
types of futures).  This makes transparent futures ideal for
troubleshooting, especially when there are errors.
}
\examples{
## Use eager futures
plan(eager)

## A global variable
a <- 0

## Create eager future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## Since 'a' is a global variable in _eager_ future 'f',
## it already has been resolved, and any changes to 'a'
## at this point will _not_ affect the value of 'f'.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)
}

