% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_lapply.R
\name{future_lapply}
\alias{future_lapply}
\title{Apply a Function over a List or Vector via Futures}
\usage{
future_lapply(x, FUN, ..., future.lazy = FALSE, future.globals = TRUE,
  future.seed = TRUE, future.scheduling = 1)
}
\arguments{
\item{x}{A vector-like object to iterate over.}

\item{FUN}{A function taking at least one argument.}

\item{...}{(optional) Additional arguments pass to \code{FUN()}.}

\item{future.lazy}{Specifies whether the futures should be resolved
lazily or eagerly (default).}

\item{future.globals}{A logical, a character vector, or a named list for
controlling how globals are handled. For details, see below section.}

\item{future.seed}{A logical or an integer (of length one or seven).
For details, see below section.}

\item{future.scheduling}{Average number of futures ("chunks") per worker.
If \code{0.0}, then a single future is used to process all elements
of \code{x}.
If \code{1.0} or \code{TRUE}, then one future per worker is used.
If \code{2.0}, then each worker will process two futures
(if there are enough elements in \code{x}).
If \code{Inf} or \code{FALSE}, then one future per element of
\code{x} is used.}
}
\value{
A list with same length and names as \code{x}.
}
\description{
Apply a Function over a List or Vector via Futures
}
\section{Global variables}{

Argument \code{future.globals} may be used to control how globals
should be handled similarly how the \code{globals} argument is used with
\code{\link{future}()}.
Since all function calls use the same set of globals, this function can do
any gathering of globals upfront (once), which is more efficient than if
it would be done for each future independently.
If \code{TRUE}, \code{NULL} or not is specified (default), then globals
are automatically identified and gathered.
If a character vector of names is specified, then those globals are gathered.
If a named list, then those globals are used as is.
In all cases, \code{FUN} and any \code{...} arguments are automatically
passed as globals to each future created as they are always needed.
}

\section{Reproducible random number generation (RNG)}{

Regardless of type of futures and scheduling ("chunking") strategy, this
function guarantees to generate the exact same sequence of random
numbers \emph{given the same initial seed / RNG state}.  This is achieved
by pregenerating the random seeds for all iterations (over \code{x}) by
using L'Ecuyer-CMRG RNG streams.  In each iteration, these seeds are set
before calling \code{FUN(x[[ii]], ...)}.
For RNG reproducibility, a fixed seed (integer) may be given, either as a
full L'Ecuyer-CMRG RNG seed (vector of 1+6 integers) or as a seed for
\code{set.seed(future.seed)} generating such a full L'Ecuyer-CMRG seed.
If \code{future.seed = TRUE}, a L'Ecuyer-CMRG RNG seed is randomly created.
If none of the function calls \code{FUN(x[[i]], ...)} uses random number
generation, then \code{future.seed = FALSE} may be used.
}

\examples{
## Regardless of the future plan, the number of workers,
## and where they are, the random numbers will be identical
plan(sequential)
y1 <- future_lapply(1:5, FUN = rnorm, future.seed = 0xBEEF)
str(y1)

plan(multiprocess)
y2 <- future_lapply(1:5, FUN = rnorm, future.seed = 0xBEEF)
str(y2)

stopifnot(all.equal(y1, y2))
}
\keyword{internal}
