% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{confint.boottest}
\alias{confint.boottest}
\title{S3 method to obtain wild cluster bootstrapped confidence intervals}
\usage{
\method{confint}{boottest}(object, ...)
}
\arguments{
\item{object}{object of type boottest}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A vector containing the boundaries of the wild cluster
bootstrapped confidence interval
}
\description{
S3 method to obtain wild cluster bootstrapped confidence intervals
}
\examples{
requireNamespace("fwildclusterboot")
data(voters)
lm_fit <- lm(
  proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
  data = voters
)
boot <- boottest(lm_fit,
  B = 9999,
  param = "treatment",
  clustid = "group_id1"
)
teststat(boot)

}
