% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{rand.t.test.w}
\alias{rand.t.test.w}
\title{Random t-test}
\usage{
rand.t.test.w(cvoutput, n.perm = 999)
}
\arguments{
\item{cvoutput}{Cross-validation output either from \code{\link{cv.w}} or
\code{\link{cv.pr.w}}.}

\item{n.perm}{The number of permutation times to get the p value, which
assesses whether using the current number of components is significantly
different from using one less.}
}
\value{
A matrix of the statistics of the cross-validation results. Each
component is described below:
\describe{
\item{\code{R2}}{the coefficient of determination (the larger, the
better the fit).}
\item{\code{Avg.Bias}}{average bias.}
\item{\code{Max.Bias}}{maximum bias.}
\item{\code{Min.Bias}}{minimum bias.}
\item{\code{RMSEP}}{root-mean-square error of prediction (the smaller,
the better the fit).}
\item{\code{delta.RMSEP}}{the percent change of RMSEP using the current
number of components than using one component less.}
\item{\code{p}}{assesses whether using the current number of components
is significantly different from using one component less, which is used
to choose the last significant number of components to avoid
over-fitting.}
\item{\code{-}}{The degree of overall compression is assessed by doing
linear regression to the cross-validation result and the observed
climate values.
\itemize{
\item \code{Compre.b0}: the intercept.
\item \code{Compre.b1}: the slope (the closer to 1, the less the
overall compression).
\item \code{Compre.b0.se}: the standard error of the intercept.
\item \code{Compre.b1.se}: the standard error of the slope.
}
}
}
}
\description{
Do a random t-test to the cross-validation results.
}
\examples{
\dontrun{
# Load modern pollen data
modern_pollen <- read.csv("/path/to/modern_pollen.csv")
                                      
# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "taxa0")
taxaColMax <- which(colnames(modern_pollen) == "taxaN")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

# Get the frequency of each climate variable fx
fx_Tmin <- fxTWAPLS::fx(modern_pollen$Tmin, bin = 0.02)
fx_gdd <- fxTWAPLS::fx(modern_pollen$gdd, bin = 20)
fx_alpha <- fxTWAPLS::fx(modern_pollen$alpha, bin = 0.002)

# MTCO
## fx
fit_Tmin <- fxTWAPLS::WAPLS.w(taxa, modern_pollen$Tmin, nPLS = 5)
## LOOCV
test_mode <- TRUE # It should be set to FALSE before running
### without fx
cv_Tmin <- fxTWAPLS::cv.w(taxa,
                          modern_pollen$Tmin,
                          nPLS = 5,
                          fxTWAPLS::WAPLS.w,
                          fxTWAPLS::WAPLS.predict.w,
                          cpus = 2, # Remove the following line
                          test_mode = test_mode)
### with fx
cv_f_Tmin <- fxTWAPLS::cv.w(taxa,
                            modern_pollen$Tmin,
                            nPLS = 5,
                            fxTWAPLS::WAPLS.w,
                            fxTWAPLS::WAPLS.predict.w,
                            usefx = TRUE,
                            fx = fx_Tmin,
                            cpus = 2, # Remove the following line
                            test_mode = test_mode)
                            
## Random t-test
rand_Tmin <- fxTWAPLS::rand.t.test.w(cv_Tmin, n.perm = 999)
rand_f_Tmin <- fxTWAPLS::rand.t.test.w(cv_f_Tmin, n.perm = 999)
}

}
\seealso{
\code{\link{cv.w}} and \code{\link{cv.pr.w}}
}
