% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{TWAPLS.predict.w}
\alias{TWAPLS.predict.w}
\title{TWA-PLS predict function}
\usage{
TWAPLS.predict.w(TWAPLSoutput, fossil_taxa)
}
\arguments{
\item{TWAPLSoutput}{The output of the \code{\link{TWAPLS.w}} training
function, either with or without \code{fx} correction.}

\item{fossil_taxa}{Fossil taxa abundance data to reconstruct past climates,
each row represents a site to be reconstructed, each column represents
a taxon.}
}
\value{
A list of the reconstruction results. Each element in the list is
described below:
\describe{
\item{\code{fit}}{the fitted values using each number of components.}
\item{\code{nPLS}}{the total number of components extracted.}
}
}
\description{
TWA-PLS predict function
}
\examples{
\dontrun{
# Load modern pollen data
modern_pollen <- read.csv("/path/to/modern_pollen.csv")
                                      
# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "taxa0")
taxaColMax <- which(colnames(modern_pollen) == "taxaN")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

# Load reconstruction data
Holocene <- read.csv("/path/to/Holocene.csv")
taxaColMin <- which(colnames(Holocene) == "taxa0")
taxaColMax <- which(colnames(Holocene) == "taxaN")
core <- Holocene[, taxaColMin:taxaColMax]

# MTCO
## Train
fit_t_Tmin <- fxTWAPLS::TWAPLS.w(taxa, modern_pollen$Tmin, nPLS = 5)
fit_tf_Tmin <- fxTWAPLS::TWAPLS.w(taxa, 
                                  modern_pollen$Tmin, 
                                  nPLS = 5, 
                                  usefx = TRUE, 
                                  fx_method = "bin",
                                  bin = 0.02)
    
## Predict
fossil_t_Tmin <- fxTWAPLS::TWAPLS.predict.w(fit_t_Tmin, core)
fossil_tf_Tmin <- fxTWAPLS::TWAPLS.predict.w(fit_tf_Tmin, core)
}

}
\seealso{
\code{\link{TWAPLS.w}}
}
