% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{history}
\alias{history}
\title{Configure History Plugin}
\usage{
history(
  key = "history",
  afterAddCommand = NULL,
  beforeAddCommand = NULL,
  executeCommand = NULL,
  stackSize = 0,
  ...
)
}
\arguments{
\item{key}{Unique identifier for the plugin (string, default: NULL).}

\item{afterAddCommand}{Callback function called after a command is added to
the undo/redo queue (JS function, default: NULL).}

\item{beforeAddCommand}{Callback function called before a command is added to
the undo/redo queue (JS function, default: NULL).}

\item{executeCommand}{Callback function called when executing a command (JS function, default: NULL).}

\item{stackSize}{Maximum length of history records to be recorded, 0 means unlimited (number, default: 0).}

\item{...}{Extra parameters.
See \url{https://g6.antv.antgroup.com/en/manual/plugin/history}.}
}
\value{
A list with the configuration settings for the history plugin.
}
\description{
Creates a configuration object for the history plugin in G6.
This plugin enables undo/redo functionality for graph operations.
}
\examples{
# Basic configuration
config <- history()

# Custom configuration
config <- history(
  key = "my-history",
  stackSize = 50,
  beforeAddCommand = JS("function(cmd, revert) {
    console.log('Before adding command:', cmd);
    // Only allow certain operations to be recorded
    return cmd.method !== 'update';
  }"),
  afterAddCommand = JS("function(cmd, revert) {
    console.log('Command added to ' + (revert ? 'undo' : 'redo') + ' stack');
  }"),
  executeCommand = JS("function(cmd) {
    console.log('Executing command:', cmd);
  }")
)
}
