/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.datatable;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.af.gMCP.gui.datatable.CellEditorE;
import org.af.gMCP.gui.datatable.CloseTabPanel;
import org.af.gMCP.gui.datatable.DataTable;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.datatable.RowModel;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.GraphView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFramePanel
extends JTabbedPane {
    private Vector<DataTable> tables = new Vector();
    private JScrollPane scrollPane;
    GraphView control;

    public DataFramePanel(RDataFrameRef dfRefW) {
        this.tables.add(new DataTable(dfRefW));
        this.addTab("Adjacency Matrix", this.getPanel(this.tables.get(0)));
    }

    private JPanel getPanel(DataTable table) {
        JPanel panel = new JPanel();
        JTable rowHeader = new JTable(new RowModel(table.getModel()));
        rowHeader.setRowHeight(table.getRowHeight());
        this.scrollPane = new JScrollPane(table);
        this.scrollPane.setRowHeaderView(rowHeader);
        rowHeader.setPreferredScrollableViewportSize(rowHeader.getPreferredSize());
        String cols = "fill:pref:grow";
        String rows = "fill:pref:grow";
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        panel.add((Component)this.scrollPane, cc.xy(1, 1));
        return panel;
    }

    public Vector<DataTable> getTable() {
        return this.tables;
    }

    public void addLayer() {
        RDataFrameRef dfRefW = new RDataFrameRef();
        DataTable dt = new DataTable(dfRefW);
        dt.setDefaultEditor(EdgeWeight.class, new CellEditorE(this.control, dt, this.tables.size()));
        for (String s : this.tables.get(0).getNames()) {
            dt.getModel().addRowCol(s);
        }
        this.tables.add(dt);
        this.addTab("Entangled graph layer " + this.tables.size(), this.getPanel(dt));
        this.setTabComponentAt(this.getTabCount() - 1, new CloseTabPanel(this));
    }

    public void removeLayer(int i) {
        this.remove(i);
        this.tables.remove(i);
        this.control.removeEntangledLayer(i);
    }

    public void renameNode(int i, String name) {
        for (DataTable dt : this.getTable()) {
            dt.renameNode(i, name);
        }
    }

    public void registerControl(GraphView control) {
        this.control = control;
        for (DataTable dt : this.getTable()) {
            dt.setDefaultEditor(EdgeWeight.class, new CellEditorE(control, dt, 0));
        }
    }

    public void setTesting(boolean b) {
        for (DataTable dt : this.getTable()) {
            dt.setTesting(b);
        }
    }

    public void delRowCol(int node) {
        for (DataTable dt : this.getTable()) {
            dt.getModel().delRowCol(node);
        }
    }

    public void addRowCol(String name) {
        for (DataTable dt : this.getTable()) {
            dt.getModel().addRowCol(name);
        }
    }

    public void setValueAt(EdgeWeight value, int row, int col, int layer) {
        this.getTable().get(layer).getModel().setValueAt(value, row, col);
    }

    public void reset() {
        for (int i = this.tables.size() - 1; i > 0; --i) {
            this.tables.remove(i);
            this.remove(i);
        }
    }
}

