% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarCorr.R
\name{VarCorr}
\alias{VarCorr}
\alias{VarCorr.galamm}
\title{Extract variance and correlation components from model}
\usage{
\method{VarCorr}{galamm}(x, sigma = 1, ...)
}
\arguments{
\item{x}{An object of class \code{galamm} returned from \code{\link{galamm}}.}

\item{sigma}{Numeric value used to multiply the standard deviations. Defaults
to 1.}

\item{...}{Other arguments passed onto other methods. Currently not used.}
}
\value{
An object of class \code{VarCorr.galamm}.
}
\description{
Extract variance and correlation components from model
}
\examples{
# Linear mixed model with heteroscedastic residuals
mod <- galamm(
  formula = y ~ x + (1 | id),
  weights = ~ (1 | item),
  data = hsced
)

# Extract information on variance and covariance
VarCorr(mod)

}
\seealso{
\code{\link[=print.VarCorr.galamm]{print.VarCorr.galamm()}} for the print function.

Other details of model fit: 
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
