% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects.R
\name{get_project_controls}
\alias{get_project_controls}
\title{Retrieve Highbond Project - Controls}
\usage{
get_project_controls(
  auth,
  objective_id = NULL,
  control_id = NULL,
  fields = NULL,
  pagesize = 50,
  waittime = 0.2
)
}
\arguments{
\item{auth}{Highbond authentication credentials, created from \code{\link{setup_highbond}}}

\item{objective_id}{Required if other parameter is blank. May obtain multiple rows.}

\item{control_id}{Required if other parameter is blank. Will get only one.}

\item{fields}{OPTIONAL. A character vector each field requested within the
project. NULL will default to all fields.}

\item{pagesize}{Defaults to 50. Maximum is 100.}

\item{waittime}{Time in seconds to wait between requests.}
}
\value{
A tibble of controls
}
\description{
"A control is a program, policy, routine, or activity that is
intended to mitigate a risk. Controls are organized by objectives, and can
be associated with one or more risks. The combination of identified risks
and corresponding controls defines the Risk Control Matrix. Controls are
also known as procedures."
}
\details{
possible fields: title, description, control_id, owner, frequency,
control_type, prevent_detect, method, status, position, created_at,
updated_at, custom_attributes, objective, walkthrough, control_test_plan,
control_tests, mitigations, owner_user, entities
}
