% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/got_palette.R
\name{scale_color_got}
\alias{scale_color_got}
\alias{scale_colour_got}
\alias{scale_colour_got_d}
\alias{scale_color_got_d}
\alias{scale_fill_got}
\alias{scale_fill_got_d}
\title{Game of Thrones colour scales}
\usage{
scale_color_got(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE,
  option = "Daenerys"
)

scale_colour_got(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE,
  option = "Daenerys"
)

scale_colour_got_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Daenerys",
  aesthetics = "colour"
)

scale_color_got_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Daenerys",
  aesthetics = "colour"
)

scale_fill_got(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE,
  option = "Daenerys"
)

scale_fill_got_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Daenerys",
  aesthetics = "fill"
)
}
\arguments{
\item{...}{parameters to \code{discrete_scale} or \code{scale_fill_gradientn}}

\item{alpha}{pass through parameter to \code{got}}

\item{begin}{The (corrected) hue in [0,1] at which the got colormap begins.}

\item{end}{The (corrected) hue in [0,1] at which the got colormap ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are as output by \code{got_pal}. If -1, the order of colors is reversed.}

\item{discrete}{generate a discrete palette? (default: \code{FALSE} - generate continuous palette)}

\item{option}{A character string indicating the colourmap to use.}

\item{aesthetics}{Character string or vector of character strings listing the name(s) of the aesthetic(s) that this scale works with.
This can be useful, for example, to apply colour settings to the `colour` and `fill` aesthetics at the same time, via `aesthetics = c("colour", "fill")`.
Parameter inherited from 'ggplot2'.}
}
\description{
Uses the Game of Thrones color scale.
}
\details{
For \code{discrete == FALSE} (the default) all other arguments are as to
\link[ggplot2]{scale_fill_gradientn} or \link[ggplot2]{scale_color_gradientn}.
Otherwise the function will return a \code{discrete_scale} with the plot-computed
number of colors.
}
\examples{
library(ggplot2)

ggplot(mtcars, aes(factor(cyl), fill=factor(vs))) +
geom_bar() +
scale_fill_got(discrete = TRUE, option = "Daenerys")

ggplot(mtcars, aes(factor(gear), fill=factor(carb))) +
geom_bar() +
scale_fill_got(discrete = TRUE, option = "Tully")

ggplot(mtcars, aes(x = mpg, y = disp, colour = hp)) +
geom_point(size = 2) +
scale_colour_got(option = "Lannister")


}
\author{
Alejandro Jiménez Rico \email{aljrico@gmail.com}
}
