% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/energy_calibrate.R
\docType{methods}
\name{energy}
\alias{energy}
\alias{energy_calibrate}
\alias{energy_calibrate-method}
\alias{has_energy}
\alias{has_calibration}
\alias{energy_calibrate,GammaSpectrum,list-method}
\alias{energy_calibrate,GammaSpectrum,PeakPosition-method}
\alias{has_energy,GammaSpectrum-method}
\alias{has_energy,GammaSpectra-method}
\alias{has_calibration,GammaSpectrum-method}
\alias{has_calibration,GammaSpectra-method}
\title{Energy Scale Calibration}
\usage{
energy_calibrate(object, lines, ...)

has_energy(object)

has_calibration(object)

\S4method{energy_calibrate}{GammaSpectrum,list}(object, lines, ...)

\S4method{energy_calibrate}{GammaSpectrum,PeakPosition}(object, lines, ...)

\S4method{has_energy}{GammaSpectrum}(object)

\S4method{has_energy}{GammaSpectra}(object)

\S4method{has_calibration}{GammaSpectrum}(object)

\S4method{has_calibration}{GammaSpectra}(object)
}
\arguments{
\item{object}{A \linkS4class{GammaSpectrum} or \linkS4class{GammaSpectra} object.}

\item{lines}{A \linkS4class{PeakPosition} object or a \code{\link{list}} of length two. If a
\code{list} is provided, each element must be a named numeric vector giving the
observed peak position ("\code{channel}") and the corresponding expected
"\code{energy}" value (in keV).}

\item{...}{Currently not used.}
}
\value{
\itemize{
\item \code{energy_calibrate()} returns a \linkS4class{GammaSpectrum} object.
\item \code{has_energy()} and \code{has_calibration()} return a \code{\link{logical}} vector.
}
}
\description{
Calibrates the energy scale of a gamma spectrum.
}
\details{
The energy calibration of a spectrum is the most tricky part. To do this,
the user must specify the position of at least three observed peaks and the
corresponding energy value (in keV). A second order polynomial model is
fitted on these energy \emph{vs} channel values, then used to predict the
new energy scale of the spectrum.

The package allows to provide the channel-energy pairs to be use. However,
the spectrum can be noisy so it is difficult to properly determine the peak
channel. In this case, a better approach may be to pre-process the spectrum
(variance-stabilization, smoothing and baseline correction) and perform a
peak detection. Once the identified peaks are satisfactory, you can set the
corresponding energy values (in keV) and use these lines to calibrate the
energy scale of the spectrum.

Regardless of the approach you choose, it is strongly recommended to check
the result before proceeding.
}
\examples{
## Import a CNF file
spc_file <- system.file("extdata/LaBr.TKA", package = "gamma")
(spc <- read(spc_file))

## Set peak positions (channel) and expected energy values
calib_lines <- list(
  channel = c(86, 495, 879),
  energy = c(238, 1461, 2615)
)

## Adjust the energy scale
(spc1 <- energy_calibrate(spc, lines = calib_lines))

## Inspect results
plot(spc1, xaxis = "energy", yaxis = "count") +
  ggplot2::geom_vline(xintercept = c(238, 1461, 2615), linetype = 3)
}
\author{
N. Frerebeau
}
\concept{energy}
