% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gargle-class.R
\name{gargle2.0_token}
\alias{gargle2.0_token}
\title{Generate a gargle token}
\usage{
gargle2.0_token(
  email = gargle_oauth_email(),
  app = gargle_client(),
  package = "gargle",
  scope = NULL,
  use_oob = gargle_oob_default(),
  credentials = NULL,
  cache = if (is.null(credentials)) gargle_oauth_cache() else FALSE,
  ...
)
}
\arguments{
\item{email}{Optional. Allows user to target a specific Google identity. If
specified, this is used for token lookup, i.e. to determine if a suitable
token is already available in the cache. If no such token is found, \code{email}
is used to pre-select the targetted Google identity in the OAuth chooser.
Note, however, that the email associated with a token when it's cached is
always determined from the token itself, never from this argument. Use \code{NA}
or \code{FALSE} to match nothing and force the OAuth dance in the browser. Use
\code{TRUE} to allow email auto-discovery, if exactly one matching token is
found in the cache. Specify just the domain with a glob pattern, e.g.
\code{"*@example.com"}, to create code that "just works" for both
\code{alice@example.com} and \code{bob@example.com}. Defaults to the option named
"gargle_oauth_email", retrieved by \code{\link[=gargle_oauth_email]{gargle_oauth_email()}}.}

\item{app}{A Google OAuth client, preferably constructed via
\code{\link[=gargle_oauth_client_from_json]{gargle_oauth_client_from_json()}}, which returns an instance of
\code{gargle_oauth_client}. For backwards compatibility, for a limited time,
gargle will still accept an "OAuth app" created with \code{\link[httr:oauth_app]{httr::oauth_app()}}.}

\item{package}{Name of the package requesting a token. Used in messages.}

\item{scope}{A character vector of scopes to request.}

\item{use_oob}{Whether to prefer out-of-band authentication. Defaults to the
value returned by \code{\link[=gargle_oob_default]{gargle_oob_default()}}.}

\item{credentials}{Advanced use only: allows you to completely customise
token generation.}

\item{cache}{Specifies the OAuth token cache. Defaults to the option named
\code{"gargle_oauth_cache"}, retrieved via \code{\link[=gargle_oauth_cache]{gargle_oauth_cache()}}.}

\item{...}{Absorbs arguments intended for use by other credential functions.
Not used.}
}
\value{
An object of class \link{Gargle2.0}, either new or loaded from the cache.
}
\description{
Constructor function for objects of class \link{Gargle2.0}.
}
\examples{
\dontrun{
gargle2.0_token()
}
}
